//
//  ViewController.m
//  PropertyAnimator
//
//  Created by Markus Stöbe on 12.03.17.
//  Copyright © 2017 Markus Stöbe. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()

@property UIViewPropertyAnimator *animator, *animator2, *animator3, *animator4, *animator5, *animator6;

@end

@implementation ViewController

- (void)viewDidLoad {
	[super viewDidLoad];
	__weak ViewController *weakSelf = self;
	

	//******************************************************************************************************************
	//* MARK: - Erstes Beispiel
	//******************************************************************************************************************
	//Der Completion-Block ändert das Text-Label des Knopfes entsprechend der Bewegungsphase sobald die Animation beendet wird
	//Ein Animator für den Button, bewegt den Button an den rechten Rand
	
	self.animator = [[UIViewPropertyAnimator alloc] initWithDuration:2.0 curve:UIViewAnimationCurveEaseInOut animations:^{
		weakSelf.moveButton.center = CGPointMake(weakSelf.view.frame.size.width-50, weakSelf.moveButton.center.y);
	}];

	//Das Setzen des Labels bewirkt auch gleichzeitig ein (unerwünschtes) Rückspringen des Buttons in die Ausgangsposition.
	//Dieses Problem rührt daher, dass der SCreen mit Autolayout aufgebaut ist, man müsste also eigentlich die Konstanten der Constraints ändern,
	//das wiederrum lässt sich mit dem Animator aber nicht animieren...
	[self.animator addCompletion:^(UIViewAnimatingPosition finalPosition) {
		[weakSelf.moveButton setEnabled:NO];
		
		switch (finalPosition) {
			case UIViewAnimatingPositionEnd:
				[weakSelf.moveButton setTitle:@"End-Position" forState:UIControlStateNormal];
				break;
			case UIViewAnimatingPositionStart:
				[weakSelf.moveButton setTitle:@"Start-Position" forState:UIControlStateNormal];
				break;
			case UIViewAnimatingPositionCurrent:
				[weakSelf.moveButton setTitle:@"Mittendrin" forState:UIControlStateNormal];
				break;
			default:
				[weakSelf.moveButton setTitle:@"finished" forState:UIControlStateNormal];
				break;
		}
	}];
	
	//******************************************************************************************************************
	//* MARK: - Spring-Demo
	//******************************************************************************************************************
	//Eine Federkurve für's Timing
	UISpringTimingParameters *springTiming = [[UISpringTimingParameters alloc] initWithDampingRatio:0.3];
	self.animator2 = [[UIViewPropertyAnimator alloc] initWithDuration:2.0 timingParameters:springTiming];

	//Ein Animator für den Button, bewegt den Button an den rechten Rand
	[self.animator2 addAnimations:^{
		weakSelf.springButton.center = CGPointMake(weakSelf.view.frame.size.width-50, weakSelf.springButton.center.y);
	}];
	//Wir deaktivieren den Button im Completion-Block, weil nach dem Ablauf der Animationen ein erneuter Tap zu einer Exception führt.
	//Man muss deshalb verhindern, dass der Animator gestartet wird, wenn sein Animation-Block leer ist.
	[self.animator2 addCompletion:^(UIViewAnimatingPosition finalPosition) {
		[weakSelf.springButton setEnabled:NO];
	}];

	//******************************************************************************************************************
	//* MARK: - Animation "scrubben"
	//******************************************************************************************************************
	//die zweite Animation bewegt das Logo von rechts nach links, gestartet wird die Animation aber nicht.
	//Statt dessen steuert der Slider die Animation über die Proerty fractionComplete
	self.animator3 = [[UIViewPropertyAnimator alloc] initWithDuration:2.0
																curve:UIViewAnimationCurveLinear
														   animations:^{
															   weakSelf.demoImage.center = CGPointMake(weakSelf.view.frame.size.width-weakSelf.demoImage.frame.size.width/2
																									   , weakSelf.demoImage.center.y);
														   }];

	//die Verknüpfung zwischen Slider und Action-Handler ist eigentlich schon im Interface-Builder hergestellt worden.
	//Wer das lieber via Code macht, hängt beides von Hand aneinander
	[self.slider addTarget:self action:@selector(sliderMoved:) forControlEvents:UIControlEventValueChanged];

	//******************************************************************************************************************
	//* MARK: - Tap to Pause
	//******************************************************************************************************************
	self.animator4 = [[UIViewPropertyAnimator alloc] initWithDuration:2.0 curve:UIViewAnimationCurveEaseInOut animations:^{
		weakSelf.pauseButton.center = CGPointMake(weakSelf.view.frame.size.width-50, weakSelf.pauseButton.center.y);
	}];
	
	//Wir deaktivieren den Button im Completion-Block, weil nach dem Ablauf der Animationen ein erneuter Tap zu einer Exception führt.
	//Man muss deshalb verhindern, dass der Animator gestartet wird, wenn sein Animation-Block leer ist.
	[self.animator4 addCompletion:^(UIViewAnimatingPosition finalPosition) {
		[weakSelf.pauseButton setEnabled:NO];
	}];


}

//******************************************************************************************************************
//* MARK: - IBActions
//******************************************************************************************************************
- (IBAction)sliderMoved:(id)sender {
	UISlider *slider = (UISlider*)sender;
	self.animator3.fractionComplete = slider.value;
}

- (IBAction)moveRight:(id)sender {
	[self.animator startAnimation];
}

- (IBAction)springRight:(id)sender {
	[self.animator2 startAnimation];
}

- (IBAction)togglePause:(id)sender {
	if ([self.animator4 isRunning]) {
		[self.animator4 pauseAnimation];
	} else {
		[self.animator4 startAnimation];
	}
}


- (IBAction)animate:(UIButton*)sender {
	__weak ViewController *weakSelf = self;

	if ([self.animator isRunning]) {
		[self.animator setReversed:YES];

//		[self.animator stopAnimation:NO];
//		[self.animator addAnimations:^{
//			weakSelf.demoButton.center = CGPointMake(weakSelf.demoButton.center.x, weakSelf.view.frame.size.height);
//		}];
//		[self.animator startAnimation];

	} else {
		[self.animator addAnimations:^{
			weakSelf.moveButton.center = CGPointMake(weakSelf.view.frame.size.width-80, weakSelf.moveButton.center.y);
		}];
		[self.animator startAnimation];
	}
}

@end
